/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.plugin;

import java.io.File;
import java.io.FileFilter;
import tiled.io.MapReader;
import tiled.io.MapWriter;
import tiled.io.PluggableMapIO;
import tiled.io.PluginLogger;

public class TiledPlugin
implements PluggableMapIO,
FileFilter {
    private MapReader reader;
    private MapWriter writer;

    public TiledPlugin(MapReader reader, MapWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public TiledPlugin(MapReader reader) {
        this(reader, null);
    }

    public TiledPlugin(MapWriter writer) {
        this(null, writer);
    }

    @Override
    public String getFilter() throws Exception {
        String filter = "";
        if (this.reader != null) {
            filter = filter + this.reader.getFilter();
        }
        if (this.writer != null) {
            filter = filter + (filter.length() > 0 ? "," : "") + this.writer.getFilter();
        }
        return filter;
    }

    @Override
    public String getName() {
        if (this.reader != null) {
            return this.reader.getName();
        }
        return this.writer.getName();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getPluginPackage() {
        return null;
    }

    @Override
    public boolean accept(File pathname) {
        return this.reader != null && this.reader.accept(pathname) || this.writer != null && this.writer.accept(pathname);
    }

    @Override
    public void setLogger(PluginLogger logger) {
    }

    public MapReader getReader() {
        return this.reader;
    }

    public MapWriter getWriter() {
        return this.writer;
    }
}

